*
* MISC
* VARIOUS ROUTINES FOR MARINA
* 27 FEB 15 - D. FINNIGAN
*
*
* VERIFY IP ADDRESS
* DOES SOME BASIC CHECKING TO DETERMINE WHETHER
* A GIVEN STRING IS A VALID DOTTED DECIMAL IP
* ADDRESS. PTR POINTS TO START OF STRING
* MUST BE NULL-TERMINATED.
*
VERIPADDR
 LDY #0 ; OFFSET WITHIN PTR
 LDA #3 ; NUMBER OF REMAINING OCTETS TO CHECK
:L PHA
 LDX #3 ; NUMBER OF REMAINING DIGITS IN THIS OCTET
:L2 LDA (PTR),Y ; CHECK DIGITS IN THIS OCTET
 BEQ :NULL ; FOUND END OF STRING
 CMP #"0"
 BCC :OUT ; OUT OF RANGE CHARACTER
 CMP #"9"+1
 BCS :OUT
 INY
 DEX  ; CHECK NEXT DIGIT IN THIS OCTET
 BPL :L2
 JMP :INVALID ; TOO MANY DIGITS IN THIS OCTET
*
* WE FOUND A NON-DIGIT CHARACTER IN THE TEST ABOVE. IF IT'S
* NOT A DOT (.) THEN THIS ADDRESS IS INVALID NOW. OTHERWISE,
* WE NEED TO BE SURE THAT THE PREVIOUS OCTET HAD AT LEAST 1
* DIGIT IN IT, OTHERWISE THE ADDRESS IS ALSO INVALID.
*
:OUT
 CMP #"."
 BNE :INVALID ; THIS ADDRESS MUST BE INVALID
*
* HERE, WE'VE FOUND A DOT. CHECK X TO SEE HOW MANY DIGITS
* CAME BEFORE THE DOT.
*
 CPX #3
 BCS :INVALID ; THERE WERE NO DIGITS
*
* MOVE ON TO NEXT OCTET
*
 INY
 PLA ; GET REMAINING OCTET COUNT BACK
 TAX
 DEX
 TXA
 BPL :L ; CHECK NEXT OCTET
 JMP :INVALID2
*
* HERE WE CHECK THE END OF STRING
*
:NULL
 CPX #3 ; CHECK DIGITS
 BCS :INVALID ; NO DIGITS
*
* NOW CHECK REMAINING OCTET COUNT
*
 PLA
 TAX
 DEX  ; SHOULD WRAP FROM 0 TO FF
 BMI :DONE ; OK, WE'RE DONE
 PHA  ; NEEDED FOR PLA BELOW
:INVALID
 PLA
:INVALID2
 SEC
 RTS
:DONE
 CLC  ; ADDRESS APPEARS TO BE OK
 RTS
*
*
*
* PRINT AN IP ADDRESS IN DOTTED DECIMAL FORM
* PTR POINTS TO START OF ADDRESS
*
PRNTIPDEC
 LDY #0
 STY ]ZFLAG ; FLAG FOR LEADING ZEROS
:L TYA
 PHA
 LDA (PTR),Y
 JSR HEXTODEC
* THREE DIGITS ARE NOW STORED STARTING AT HEXDECTMP+1
* WE WILL SKIP LEADING ZEROS
 LDA HEXDECTMP+1
 CMP #"0" ; IS IT A ZERO?
 BEQ :N ; YES, SO SKIP IT
 JSR COUT
 STA ]ZFLAG ; WE'VE PRINTED A NON-ZERO DIGIT
:N LDA HEXDECTMP+2
 CMP #"0" ; IS IT A ZERO?
 BNE :N2 ; NO, SO JUST PRINT IT
 LDX ]ZFLAG ; PRINTED A NON-ZERO YET?
 BEQ :N3 ; NO, SO MOVE ON
:N2 JSR COUT
:N3 LDA HEXDECTMP+3
 JSR COUT
 PLA
 TAY
 INY
 CPY #4
 BCS :N4
 LDA #"."
 JSR COUT
:N4 LDA #0
 STA ]ZFLAG ; RESET ZERO FLAG
 CPY #4
 BNE :L
 RTS
]ZFLAG DFB 0
*
* CONVERT A SINGLE HEX BYTE TO UP TO 3 ASCII DECIMAL DIGITS
HEXTODEC
 STA HEXDECTMP
 LDX #0 ; COUNTER FOR HUNDREDS PLACE
 STX HEXDECTMP+1
:L SEC
 SBC #100
 BCC :UNDERFLOW
 INX  ; ONE MORE SUCCESSFUL SUBTRACTION
 STA HEXDECTMP ; STORE RESULT
 STX HEXDECTMP+1
 BNE :L ; ALWAYS TAKEN
:UNDERFLOW
 LDA HEXDECTMP+1
 ORA #$B0 ; CONVERT TO ASCII
 STA HEXDECTMP+1
 LDX #0 ; 10'S PLACE COUNTER
 STX HEXDECTMP+2
 LDA HEXDECTMP
:L2 SEC
 SBC #10
 BCC :UNDERFLOW2
 INX
 STA HEXDECTMP
 STX HEXDECTMP+2
 BNE :L2
:UNDERFLOW2
 LDA HEXDECTMP+2
 ORA #$B0
 STA HEXDECTMP+2
 LDA HEXDECTMP
 ORA #$B0
 STA HEXDECTMP+3
 RTS
HEXDECTMP DS 4
*
* IP TO HEX
* TAKE A DOTTED DECIMAL IP ADDRESS AND CONVERT IT TO
* 4 HEX DIGITS. PTR POINTS TO DECIMAL IP.
IPTOHEX
 LDY #0
 LDX #0 ; IPHEXTMP OFFSET
 STX IPHEXTMP
* GET NEXT DIGIT FROM PTR
:NEXTDIGIT
 LDA (PTR),Y
 BEQ :DONE
 CMP #"."
 BNE :TESTDIGIT
* MOVE TO NEXT GROUP
 INX
 CPX #4
 BEQ :DONE ; ALL DONE
 LDA #0
 STA IPHEXTMP,X
 INY
 BNE :NEXTDIGIT
* SKIP OUT OF RANGE CHARACTER
:OUT
 INY
 BNE :NEXTDIGIT
* TEST DIGIT RANGE 0-9
:TESTDIGIT
 CMP #"0"
 BCC :OUT ; OUT OF RANGE CHARACTER
 CMP #"9"+1
 BCS :OUT
 AND #%00001111 ; MASK OUT HIGH NYBBLE
 PHA
* MULTIPLY CURRENT HEX DIGIT BY 10
:MUL10
 LDA IPHEXTMP,X
 BEQ :ADD ; NO NEED TO MULTIPLY 0
 ASL  ; MULTIPLY BY 2
 PHA
 STA IPHEXTMP,X
 PLA
 ASL
 ASL  ; MULTIPLY BY 8
 CLC
 ADC IPHEXTMP,X ; ADD 2*X + 8*X
 STA IPHEXTMP,X
* ADD STORED DIGIT
:ADD
 PLA
 CLC
 ADC IPHEXTMP,X
 STA IPHEXTMP,X
 INY
 BPL :NEXTDIGIT
:DONE RTS
IPHEXTMP DS 4
